---------------------------------------------------------------------------------------------------------
-- BEGIN HEADER
---------------------------------------------------------------------------------------------------------
-- DDL for Alkindi Schema Model Version 0.5
-- DDL creates recalc stats package
-- Myles Weber, Appian Corporation
-- Weber@AppianCorp.com
-- October 7, 2000
-- Date Created: October 7, 2000 MSW
-- Date Updated: October 7, 2000 MSW
---------------------------------------------------------------------------------------------------------
-- END HEADER
---------------------------------------------------------------------------------------------------------

---------------------------------------------------------------------------------------------------------
-- BEGIN CHANGE LOG SINCE VERSION 0.4
---------------------------------------------------------------------------------------------------------
-- WHO WHEN   WHAT
-- MSW 100600 Moved sp_INS_ReCalcStats to its own file, ddl_pkg_calc5.sql
-- MSW 100600 pkg_ALKINDI_RECALC_STAT created
---------------------------------------------------------------------------------------------------------
-- END CHANGE LOG SINCE VERSION 0.4
---------------------------------------------------------------------------------------------------------

CREATE OR REPLACE PACKAGE pkg_ALKINDI_RECALC_STAT
AS

  PROCEDURE sp_INS_ReCalcStats(
	o_ERROR_CODE			OUT		NUMBER);

END pkg_ALKINDI_RECALC_STAT;
/

-- ==========================================================================================

SHOW ERRORS

-- ==========================================================================================

CREATE OR REPLACE PACKAGE BODY pkg_ALKINDI_RECALC_STAT
AS

  PROCEDURE sp_INS_ReCalcStats(
	o_ERROR_CODE			OUT		NUMBER)

   IS 
	
	v_Cursor		NUMBER;
	v_Truncate_String	VARCHAR2(100);

   BEGIN
	o_ERROR_CODE	:= 0;
	v_CURSOR 		:= DBMS_SQL.OPEN_CURSOR;
	v_Truncate_String:= 'TRUNCATE TABLE PRODUCT_STAT';
	dbms_sql.parse(v_CURSOR, v_Truncate_String, DBMS_SQL.V7);
	v_Truncate_String:= 'TRUNCATE TABLE USER_STAT';
	dbms_sql.parse(v_CURSOR, v_Truncate_String, DBMS_SQL.V7);
	v_Truncate_String:= 'TRUNCATE TABLE PRODUCT_CLUSTER_STAT';
	dbms_sql.parse(v_CURSOR, v_Truncate_String, DBMS_SQL.V7);
	v_Truncate_String:= 'TRUNCATE TABLE USER_CLUSTER_STAT';
	dbms_sql.parse(v_CURSOR, v_Truncate_String, DBMS_SQL.V7);
	v_Truncate_String:= 'TRUNCATE TABLE USER_PRODUCT_CLUSTER_STAT';
	dbms_sql.parse(v_CURSOR, v_Truncate_String, DBMS_SQL.V7);

	DBMS_SQL.CLOSE_CURSOR(V_CURSOR);	

	INSERT INTO PRODUCT_STAT (PRODUCT_ID, PRODUCT_WEIGHT, TOTAL_USER_EVAL, AVG_USER_EVAL, TOTAL_USER_SEEN, FRACTION_USER_SEEN)
	SELECT PRODUCT_ID, 1/COUNT(PRODUCT_ID), 0, 0, 0, 0
	  FROM REL_PRODUCT_CLUSTER
    GROUP BY PRODUCT_ID;

	UPDATE PRODUCT_STAT S
	   SET (S.AVG_USER_EVAL, S.TOTAL_USER_SEEN) = (SELECT AVG(E.EVALUATION_SCALE_ID), COUNT(E.EVALUATION_SCALE_ID)
	  FROM EVALUATION E
	 WHERE E.EVALUATION_SCALE_ID NOT IN (-1,0)
	   AND E.PRODUCT_ID = S.PRODUCT_ID
    GROUP BY E.PRODUCT_id);

	UPDATE PRODUCT_STAT S
	   SET (S.TOTAL_USER_EVAL) = (SELECT COUNT(E.EVALUATION_SCALE_ID)
	  FROM EVALUATION E
	 WHERE E.EVALUATION_SCALE_ID NOT IN (0)
	   AND E.PRODUCT_ID = S.PRODUCT_ID
    GROUP BY E.PRODUCT_id);

	UPDATE PRODUCT_STAT S1
	   SET (S1.FRACTION_USER_SEEN) = (SELECT s2.TOTAL_USER_SEEN/s2.TOTAL_USER_EVAL
	  FROM PRODUCT_STAT S2
	 WHERE S1.PRODUCT_ID = S2.PRODUCT_ID);

-- MSW, Don't know how to determine new movies yet.  We'll assume all movies are old.
	UPDATE PRODUCT_STAT S
	   SET S.NEW_ADDITION_IND = 0;

-- ================================================

	INSERT INTO USER_STAT (USER_ID, TOTAL_PROD_EVAL, AVG_PROD_EVAL, TOTAL_PROD_SEEN, FRACTION_PROD_SEEN)
	SELECT DISTINCT USER_ID, 0, 0, 0, 0
	  FROM REL_USER_CLUSTER;

	UPDATE USER_STAT S
	   SET (S.AVG_PROD_EVAL, S.TOTAL_PROD_SEEN) = (SELECT AVG(E.EVALUATION_SCALE_ID), COUNT(E.EVALUATION_SCALE_ID)
	  FROM EVALUATION E
	 WHERE E.EVALUATION_SCALE_ID NOT IN (-1,0)
	   AND E.USER_ID = S.USER_ID
    GROUP BY E.USER_ID);

	UPDATE USER_STAT S
	   SET (S.TOTAL_PROD_EVAL) = (SELECT COUNT(E.EVALUATION_SCALE_ID)
	  FROM EVALUATION E
	 WHERE E.EVALUATION_SCALE_ID NOT IN (0)
	   AND E.USER_ID = S.USER_ID
    GROUP BY E.USER_id);

	UPDATE USER_STAT S1
	   SET (S1.FRACTION_PROD_SEEN) = (SELECT s2.TOTAL_PROD_SEEN/s2.TOTAL_PROD_EVAL
	  FROM USER_STAT S2
	 WHERE S1.USER_ID = S2.USER_ID);

-- ================================================

	INSERT INTO PRODUCT_CLUSTER_STAT (PRODUCT_CLUSTER_ID, TOTAL_PROD_IN_PC, TOTAL_NEW_PROD_IN_PC, TOTAL_OLD_PROD_IN_PC, W_TOTAL_PROD_IN_PC, W_TOTAL_NEW_PROD_IN_PC, W_TOTAL_OLD_PROD_IN_PC)
	SELECT DISTINCT PRODUCT_CLUSTER_ID, COUNT(PRODUCT_ID), 0, 0, 0, 0, 0
	  FROM REL_PRODUCT_CLUSTER
    GROUP BY PRODUCT_CLUSTER_ID;

	UPDATE PRODUCT_CLUSTER_STAT S
	   SET (S.W_TOTAL_PROD_IN_PC) = (SELECT SUM(P.PRODUCT_WEIGHT)
	  FROM PRODUCT_STAT P, REL_PRODUCT_CLUSTER R
	 WHERE P.PRODUCT_ID = R.PRODUCT_ID
	   AND S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID
    GROUP BY R.PRODUCT_CLUSTER_ID);

	UPDATE PRODUCT_CLUSTER_STAT S
	   SET (S.TOTAL_NEW_PROD_IN_PC, S.W_TOTAL_NEW_PROD_IN_PC) = (SELECT COUNT(P.PRODUCT_ID), SUM(P.PRODUCT_WEIGHT)
	  FROM PRODUCT_STAT P, REL_PRODUCT_CLUSTER R
	 WHERE P.NEW_ADDITION_IND = 1
	   AND P.PRODUCT_ID = R.PRODUCT_ID
	   AND S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID
    GROUP BY R.PRODUCT_CLUSTER_ID);

	UPDATE PRODUCT_CLUSTER_STAT S
	   SET (S.TOTAL_NEW_PROD_IN_PC, S.W_TOTAL_NEW_PROD_IN_PC) = (SELECT COUNT(P.PRODUCT_ID), SUM(P.PRODUCT_WEIGHT)
	  FROM PRODUCT_STAT P, REL_PRODUCT_CLUSTER R
	 WHERE P.NEW_ADDITION_IND = 0
	   AND P.PRODUCT_ID = R.PRODUCT_ID
	   AND S.PRODUCT_CLUSTER_ID = R.PRODUCT_CLUSTER_ID
    GROUP BY R.PRODUCT_CLUSTER_ID);


--	UPDATE PRODUCT_CLUSTER_STAT S1
--	   SET (S1.TOTAL_OLD_PROD_IN_PC, S1.W_TOTAL_OLD_PROD_IN_PC) = (SELECT s2.TOTAL_PROD_IN_PC - TOTAL_NEW_PROD_IN_PC, W_TOTAL_PROD_IN_PC - W_TOTAL_NEW_PROD_IN_PC
--	  FROM PRODUCT_CLUSTER_STAT S2
--	 WHERE S1.PRODUCT_CLUSTER_ID = S2.PRODUCT_CLUSTER_ID);

-- ================================================

	INSERT INTO USER_CLUSTER_STAT (USER_CLUSTER_ID, TOTAL_USER_IN_UC)
	SELECT DISTINCT USER_CLUSTER_ID, COUNT(USER_ID)
	  FROM REL_USER_CLUSTER
    GROUP BY USER_CLUSTER_ID;

-- ================================================

	INSERT INTO USER_PRODUCT_CLUSTER_STAT (USER_ID,PRODUCT_CLUSTER_ID, TOTAL_PROD_EVAL, AVG_PROD_EVAL, TOTAL_PROD_SEEN, FRACTION_OF_EVAL_SEEN)
	SELECT DISTINCT USER_ID, PRODUCT_CLUSTER_ID, 0, 0, 0, 0
	  FROM EVALUATION, REL_PRODUCT_CLUSTER
	 WHERE EVALUATION.PRODUCT_ID = REL_PRODUCT_CLUSTER.PRODUCT_ID(+);

	UPDATE USER_PRODUCT_CLUSTER_STAT S
	   SET (S.TOTAL_PROD_EVAL) = (SELECT count(E.EVALUATION_SCALE_ID)
	  FROM EVALUATION E
	     , REL_PRODUCT_CLUSTER R
	 WHERE E.PRODUCT_ID = R.PRODUCT_ID(+)
	   AND E.EVALUATION_SCALE_ID <> -1
	   AND E.USER_ID = S.USER_ID
	   AND R.PRODUCT_CLUSTER_ID = S.PRODUCT_CLUSTER_ID
    GROUP BY R.product_cluster_id
	     , E.user_id);

	UPDATE USER_PRODUCT_CLUSTER_STAT S
	   SET (S.TOTAL_PROD_SEEN, S.AVG_PROD_EVAL) = (SELECT count(E.EVALUATION_SCALE_ID), AVG(E.EVALUATION_SCALE_ID)
	  FROM EVALUATION E
	     , REL_PRODUCT_CLUSTER R
	 WHERE E.PRODUCT_ID = R.PRODUCT_ID(+)
	   AND E.EVALUATION_SCALE_ID NOT IN (-1,0)
	   AND E.USER_ID = S.USER_ID
	   AND R.PRODUCT_CLUSTER_ID = S.PRODUCT_CLUSTER_ID
    GROUP BY R.product_cluster_id
	     , E.user_id);

	UPDATE USER_PRODUCT_CLUSTER_STAT S1
	   SET (S1.FRACTION_OF_EVAL_SEEN) = (SELECT s2.TOTAL_PROD_SEEN/s2.TOTAL_PROD_EVAL
	  FROM USER_PRODUCT_CLUSTER_STAT S2
	 WHERE S1.PRODUCT_CLUSTER_ID = S2.PRODUCT_CLUSTER_ID
	   AND S1.USER_ID = S2.USER_ID);



   EXCEPTION
	WHEN OTHERS THEN
		o_ERROR_CODE	:= -1;
 END sp_INS_ReCalcStats;


-- ==========================================================================================


END pkg_ALKINDI_RECALC_STAT;
/

SHOW ERRORS
